/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider.java;

import com.sun.star.document.XScriptInvocationContext;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.ClassLoaderFactory;
import com.sun.star.script.framework.provider.NoSuitableClassLoaderException;
import com.sun.star.script.framework.provider.ScriptContext;
import com.sun.star.script.framework.provider.java.Resolver;
import com.sun.star.script.framework.provider.java.ScriptDescriptor;
import com.sun.star.script.framework.provider.java.ScriptProxy;
import com.sun.star.script.provider.ScriptExceptionRaisedException;
import com.sun.star.script.provider.ScriptFrameworkErrorException;
import com.sun.star.script.provider.XScript;
import com.sun.star.script.provider.XScriptContext;
import com.sun.star.uno.Any;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.XComponentContext;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

class ScriptImpl
implements XScript {
    private ScriptMetaData metaData;
    private XComponentContext m_xContext;
    private XModel m_xModel;
    private XScriptInvocationContext m_xInvocContext;
    private XMultiComponentFactory m_xMultiComponentFactory;
    private Resolver m_resolutionPolicy;

    ScriptImpl(XComponentContext xComponentContext, Resolver resolver, ScriptMetaData scriptMetaData, XModel xModel, XScriptInvocationContext xScriptInvocationContext) throws RuntimeException {
        this.metaData = scriptMetaData;
        this.m_xContext = xComponentContext;
        this.m_xModel = xModel;
        this.m_xInvocContext = xScriptInvocationContext;
        this.m_resolutionPolicy = resolver;
        try {
            this.m_xMultiComponentFactory = this.m_xContext.getServiceManager();
        }
        catch (Exception exception) {
            LogUtils.DEBUG(LogUtils.getTrace(exception));
            throw new RuntimeException("Error constructing  ScriptProvider: " + exception.getMessage());
        }
        LogUtils.DEBUG("ScriptImpl [java] script data = " + scriptMetaData);
    }

    public Object invoke(Object[] objectArray, short[][] sArray, Object[][] objectArray2) throws ScriptFrameworkErrorException, com.sun.star.reflection.InvocationTargetException {
        ScriptExceptionRaisedException scriptExceptionRaisedException;
        long l;
        Object object;
        LogUtils.DEBUG("** ScriptProviderForJava::invoke: Starting...");
        sArray[0] = new short[0];
        objectArray2[0] = new Object[0];
        Map map = this.metaData.getLanguageProperties();
        ScriptDescriptor scriptDescriptor = new ScriptDescriptor(this.metaData.getLanguageName());
        ClassLoader classLoader = null;
        try {
            LogUtils.DEBUG("Classloader starting...");
            classLoader = ClassLoaderFactory.getURLClassLoader(this.metaData);
            LogUtils.DEBUG("Classloader finished...");
        }
        catch (MalformedURLException malformedURLException) {
            throw new ScriptFrameworkErrorException(malformedURLException.getMessage(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 3);
        }
        catch (NoSuitableClassLoaderException noSuitableClassLoaderException) {
            throw new ScriptFrameworkErrorException(noSuitableClassLoaderException.getMessage(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 0);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new ScriptFrameworkErrorException(arrayStoreException.getMessage(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 0);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object[] objectArray3 = null;
        LogUtils.DEBUG("Parameter Mapping...");
        XScriptContext xScriptContext = ScriptContext.createContext(this.m_xModel, this.m_xInvocContext, this.m_xContext, this.m_xMultiComponentFactory);
        scriptDescriptor.addArgumentType(XScriptContext.class);
        arrayList.add(xScriptContext);
        for (int i = 0; i < objectArray.length; ++i) {
            scriptDescriptor.addArgumentType(objectArray[i].getClass());
            arrayList.add(objectArray[i]);
        }
        if (!arrayList.isEmpty()) {
            objectArray3 = arrayList.toArray();
        }
        LogUtils.DEBUG("ScriptProxy starting... ");
        ScriptProxy scriptProxy = null;
        try {
            object = this.metaData.getLanguageName().substring(0, this.metaData.getLanguageName().lastIndexOf(46));
            LogUtils.DEBUG("About to load Class " + (String)object + " starting... ");
            l = new Date().getTime();
            scriptExceptionRaisedException = classLoader.loadClass((String)object);
            long l2 = new Date().getTime();
            LogUtils.DEBUG("loadClass took: " + String.valueOf(l2 - l) + "milliseconds");
            try {
                LogUtils.DEBUG("class loaded ... ");
                scriptProxy = this.m_resolutionPolicy.getProxy(scriptDescriptor, (Class)scriptExceptionRaisedException);
                LogUtils.DEBUG("script resolved ... ");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ScriptFrameworkErrorException(noSuchMethodException.getMessage(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ScriptFrameworkErrorException(classNotFoundException.getMessage(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 2);
        }
        LogUtils.DEBUG("Starting Invoke on Proxy ...");
        object = null;
        try {
            l = new Date().getTime();
            object = scriptProxy.invoke(objectArray3);
            long l3 = new Date().getTime();
            LogUtils.DEBUG("invoke took: " + String.valueOf(l3 - l) + "milliseconds");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ScriptFrameworkErrorException(illegalArgumentException.getMessage(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 0);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ScriptFrameworkErrorException(illegalAccessException.getMessage(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 0);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            scriptExceptionRaisedException = new ScriptExceptionRaisedException(throwable.toString());
            scriptExceptionRaisedException.lineNum = -1;
            scriptExceptionRaisedException.scriptName = this.metaData.getLanguageName();
            scriptExceptionRaisedException.language = "Java";
            scriptExceptionRaisedException.exceptionType = throwable.getClass().getName();
            throw new com.sun.star.reflection.InvocationTargetException("Scripting Framework error executing script ", null, (Object)scriptExceptionRaisedException);
        }
        catch (Exception exception) {
            ScriptExceptionRaisedException scriptExceptionRaisedException2 = new ScriptExceptionRaisedException(exception.toString());
            scriptExceptionRaisedException2.lineNum = -1;
            scriptExceptionRaisedException2.scriptName = this.metaData.getLanguageName();
            scriptExceptionRaisedException2.language = "Java";
            scriptExceptionRaisedException2.exceptionType = exception.getClass().getName();
            throw new com.sun.star.reflection.InvocationTargetException("Scripting Framework error executing script ", null, (Object)scriptExceptionRaisedException2);
        }
        if (object == null) {
            LogUtils.DEBUG("Got Nothing Back");
            Any any = new Any(new Type(), null);
            object = any;
        } else {
            LogUtils.DEBUG("Got object " + object);
        }
        return object;
    }
}

